#Abstract Collection and Abstract Model

The abstract cellection and model, are designed to be an easier way to interact with our rest api.  They are written is such a way so that they are fully compatible with a normal model or collection, so you can use them the same way without having to worry about interfering with any functionality.  

If you are not using the model or collection in conjunction with the api, there is no additional benefits.

## Look Up
```javascript
var Collection = AbstractCollection.extend({
    // This name should match a title in the resource-directory.json
    // This is not a required field, but is useful because it provides 
    // additional information as to what this collection represents   
    resourceName: 'my-resource'
}); 

var collection = new Collection();

// This will use the resource name to get the resource model without having to import:
// app-resources
var myResource = collection.getResource()
myResource.formatHref(); // => url:my-resource

// This can take a resource name if for some reason you ever need too look up a different url
var otherResource = collection.getResource('other-resource');
myResource.formatHref(); // => url:other-resource
``` 
In general the getResource will be used in one of two ways:

```javascript
var NoArgsCollection = AbstractCollection.extend({
    resourceName: 'my-resource',
    
    // Use it directly in the url function if no arguments outside the collection is needed
    // This Invoked Automatically on fetch or save
    url: function() {
        var resource = this.getResource();
        var internalArg = this.whatever; 
        
        return resource.formatHref({
            whatever: internalArg
        });
    }
}); 

var WithArgCollection = AbstractCollection.extend({
    resourceName: 'my-resource',
        
    // Don't override the url function it requires an argument.
    // It won't break anything, but it causes unneeded confusion and
    // likely partials as well 
    // This will have to be manually invoked at fetch or save
    getUrl: function(myArg) {
        var resource = this.getResource(); 
        
        return resource.formatHref({
            whatever: myArg
        });
    }
});
```

Similarly fetch or save should only be overridden when you are not changing the signature of fetch and save.  Otherwise, it is better to create a function with a unique name that accepts the new arguments and pacts them into a fetch or save. 
 
## Events

This collection and model has added 4 new events to listen for
1. fetch:success
2. fetch:error
3. save:success
4. save:error 

They are all called with the same arguments as jQuery.XHR event. 

- collection or model:  The same collection or model that was used to fetch or save
- response:  the XHR object 
- options:  the fetch option sent with the request 
```javascript
function callback(collection, response, options) {}

view.listenTo(collection, 'fetch:success', callback);
```

## Patterns 

It is a good habit to document the endpoint that the collection or model is using within the collection or model. This way future developers will not need to do an extensive look ups to understand the resource that it is associated with.

# Singleton Collection/Model
The singleton collection and model is designed to trap the XHR response in deferred object that is created during the initialization of the collection. This allows you to imitatively define async callback events after the initalization of the model or collection, opposed to having to wait for the point of being fetched. 

Additionally the singleton collection and model extend the abstract collection and model, so listeners can also be used to monitor the data fetching.
